/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.filesystem.s3;

import com.amazon.s3.ListEntry;
import com.aptana.ide.filesystem.s3.S3FileStore;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.filesystem.provider.FileTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class S3FileTree
extends FileTree {
    private static final String SEPARATOR = "/";
    private List<ListEntry> entries;

    protected S3FileTree(IFileStore treeRoot, List<ListEntry> entries) {
        super(treeRoot);
        this.entries = entries;
    }

    public IFileInfo[] getChildInfos(IFileStore store) {
        if (!(store instanceof S3FileStore)) {
            return null;
        }
        List<ListEntry> matches = this.getChildEntries(store);
        ArrayList<FileInfo> infos = new ArrayList<FileInfo>();
        for (ListEntry match : matches) {
            FileInfo fileInfo = this.generateFileInfo(match);
            infos.add(fileInfo);
        }
        return infos.toArray(new IFileInfo[infos.size()]);
    }

    private FileInfo generateFileInfo(ListEntry match) {
        String name = match.key;
        int lastSlash = name.lastIndexOf(SEPARATOR);
        boolean isDirectory = match instanceof PsuedoDirEntry;
        if (lastSlash != -1) {
            if (lastSlash == name.length() - 1) {
                name = name.substring(0, lastSlash);
                isDirectory = true;
                lastSlash = name.lastIndexOf(SEPARATOR);
                if (lastSlash != -1) {
                    name = name.substring(lastSlash + 1);
                }
            } else if ((name = name.substring(lastSlash)).startsWith(SEPARATOR)) {
                name = name.substring(1);
            }
        }
        FileInfo fileInfo = new FileInfo(name);
        fileInfo.setExists(true);
        fileInfo.setLastModified(match.lastModified.getTime());
        fileInfo.setLength(match.size);
        fileInfo.setDirectory(isDirectory);
        return fileInfo;
    }

    private List<ListEntry> getChildEntries(IFileStore store) {
        S3FileStore s3Store = (S3FileStore)store;
        String key = s3Store.getKey();
        if (key.startsWith(SEPARATOR)) {
            key = key.substring(1);
        }
        HashSet<String> pseudoDirs = new HashSet<String>();
        ArrayList<ListEntry> matches = new ArrayList<ListEntry>();
        for (ListEntry entry : this.entries) {
            String relative = entry.key;
            if (relative.startsWith(SEPARATOR)) {
                relative = relative.substring(1);
            }
            if (key.length() != 0 && !relative.startsWith(String.valueOf(key) + SEPARATOR)) continue;
            if ((relative = relative.substring(key.length())).startsWith(SEPARATOR)) {
                relative = relative.substring(1);
            }
            if (relative.endsWith(SEPARATOR)) {
                relative = relative.substring(0, relative.length() - 1);
            }
            if (relative.length() == 0) continue;
            int index = relative.indexOf(SEPARATOR);
            if (index != -1) {
                String dirName = relative.substring(0, index);
                if (pseudoDirs.contains(dirName)) continue;
                PsuedoDirEntry dirEntry = new PsuedoDirEntry(dirName);
                pseudoDirs.add(dirEntry.key);
                matches.add(dirEntry);
                continue;
            }
            matches.add(entry);
        }
        return matches;
    }

    public IFileStore[] getChildStores(IFileStore store) {
        if (!(store instanceof S3FileStore)) {
            return null;
        }
        S3FileStore s3Store = (S3FileStore)store;
        List<ListEntry> matches = this.getChildEntries((IFileStore)s3Store);
        ArrayList<IFileStore> childrenStores = new ArrayList<IFileStore>();
        for (ListEntry match : matches) {
            String childName = match.key;
            if (childName.endsWith(SEPARATOR)) {
                childName = childName.substring(0, childName.length() - 1);
            }
            childrenStores.add(s3Store.getChild(childName));
        }
        return childrenStores.toArray(new IFileStore[childrenStores.size()]);
    }

    public IFileInfo getFileInfo(IFileStore store) {
        if (!(store instanceof S3FileStore)) {
            return null;
        }
        S3FileStore s3Store = (S3FileStore)store;
        String key = s3Store.getKey();
        for (ListEntry entry : this.entries) {
            String entryKey = entry.key;
            if (entryKey.startsWith(SEPARATOR)) {
                entryKey = entryKey.substring(1);
            }
            if (entryKey.endsWith(SEPARATOR)) {
                entryKey = entryKey.substring(0, entryKey.length() - 1);
            }
            if (!entryKey.equals(key)) continue;
            return this.generateFileInfo(entry);
        }
        return s3Store.fetchInfo();
    }

    private class PsuedoDirEntry
    extends ListEntry {
        public PsuedoDirEntry(String dirName) {
            this.size = 0L;
            this.lastModified = new Date();
            this.key = dirName;
        }
    }
}

